This is a collection of scripts to help manage and clean the Wikibase database by Kunstenpunt.

## Overview

- `delete_query_results.py` allows to delete all entities given by a certain query. This query can be modified by editing the script.

- `resolve_double_redirects.py` will make sure all redirects pointing to final redirects in chains are changed to also point to the target entity. Running this multiple times will eventually remove any redirect chains from your database.

- `fix_statement_redirects.py` will modify all statements pointing to a redirect, to instead point to the target entity. This happens both on the entity and qualifier level.

- `fix_statement_redirects_threaded.py` is an experimental version of `fix_statement_redirects.py`, while it is funcitonal, it is not as cleanly written as the other version and isn't kept up to date with logging and output features.

- `fix_entity_prop_redirects.py` is an earlier script that only fixes statements that point directly from an entity to a redirect (and doesn't handle qualifiers). It should not be necessary to run this if `fix_statement_redirects.py` was already executed.

## Login info

Login info is kept in a separate file in `config/secrets.py`:
```
password = 'BOTNAME@BOT_PASSWORD'
user = 'USERNAME'
```

## Logging and output

The following cleanup scripts allow for optional error logging by passing an argument (the log file path) to the script:
- `delete_query_results.py`
- `fix_entity_prop_redirects.py`
- `fix_statement_redirects.py`
- `resolve_double_redirects.py`

All scripts generate output messages to indicate current actions and progress.

## Batch file

