import os, sys
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from wikibaseintegrator.wbi_helpers import mediawiki_api_call_helper, execute_sparql_query

from config.wikibase_setup import login, wbi
from utils.utils import entity_id_from_uri

# Deze query vraagt 3 redirects op naar Q1385059, de entiteit met het
# meeste redirects in de database (94!)
query = """
PREFIX kp:<https://kg.kunsten.be/entity/>

SELECT ?old
WHERE {
  ?old owl:sameAs kp:Q1385059 .
}
LIMIT 3
"""

query_result = execute_sparql_query(query)
chain_start = entity_id_from_uri(query_result['results']['bindings'][0]['old']['value'])
chain_middle = entity_id_from_uri(query_result['results']['bindings'][1]['old']['value'])
chain_end = entity_id_from_uri(query_result['results']['bindings'][2]['old']['value'])

# Jammer genoeg werkt dit niet aangezien we geen chains mogen maken van de MWApi :(

print(f'Making {chain_start} point to {chain_middle}')
params = {
    "action": "wbcreateredirect",
    "from": chain_start,
    "to": chain_middle,
}
result = mediawiki_api_call_helper(data=params, login=login)
print(result)

print(f'Making {chain_middle} point to {chain_end}')
params = {
    "action": "wbcreateredirect",
    "from": chain_middle,
    "to": chain_end,
}
result = mediawiki_api_call_helper(data=params, login=login)
print(result)
    