import json, os, sys

sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from wikibaseintegrator.wbi_helpers import (
    mediawiki_api_call_helper,
    execute_sparql_query,
)

from config.wikibase_setup import login, wbi
from utils.utils import entity_id_from_uri

# Deze query vraagt 3 redirects op naar Q1385059, de entiteit met het
# meeste redirects in de database (94!)
query = """
PREFIX kp:<https://kg.kunsten.be/entity/>

SELECT ?old
WHERE {
  ?old owl:sameAs kp:Q1385059 .
}
LIMIT 1
"""

query_result = execute_sparql_query(query)
redirect_id = entity_id_from_uri(query_result["results"]["bindings"][0]["old"]["value"])

query = """
PREFIX kp:<https://kg.kunsten.be/entity/>

SELECT ?subject
WHERE {
  ?subject ?predicate kp:Q1385059 .
  ?subject wikibase:rank [] .
}
LIMIT 10
"""

query_result = execute_sparql_query(query)
edit_list = [
    entity_id_from_uri(row["subject"]["value"], prefix="https://kg.kunsten.be/entity/statement/").replace("-", "$", 1)
    for row in query_result["results"]["bindings"]
]
original_id = "Q1385059"

for index, statement_id in enumerate(edit_list):
    print(
        f"Changing statement {statement_id} to point to redirect: {original_id} -> {redirect_id} ({index + 1}/{len(edit_list)})"
    )

    params = {
        "action": "wbgetclaims",
        "claim": statement_id,
    }
    result = mediawiki_api_call_helper(data=params, login=login, is_bot=True)
    result_json = json.dumps(list(result["claims"].values())[0][0])
    # Het lijkt alsof enkel de numeric-id aanpassen ook voldoende is,
    # maar voor het zeker toch beide nog doen
    updated_json = result_json.replace(f'"{original_id}"', f'"{redirect_id}"')
    updated_json = updated_json.replace(
        f'"numeric-id": {original_id[1:]}', f'"numeric-id": {redirect_id[1:]}'
    )

    params = {
        "action": "wbsetclaim",
        "claim": updated_json,
        "summary": "update value to accomodate redirect",
    }

    mediawiki_api_call_helper(data=params, login=login, is_bot=True)
