import sys
from wikibaseintegrator.wbi_helpers import (
    execute_sparql_query,
    mediawiki_api_call_helper,
)

from config.wikibase_setup import login
from utils.csv_logger import Logger
from utils.utils import double_redirects_query_result_to_edit_list

query = """
SELECT DISTINCT ?old ?new ?newer
WHERE {
  ?old owl:sameAs ?new .
  FILTER NOT EXISTS { ?new wikibase:sitelinks [] }
  ?new owl:sameAs ?newer .
  ?newer wikibase:sitelinks [] .
}
"""

print(f"Executing query to obtain redirects that point to single redirects:\n{query}")
query_result = execute_sparql_query(query)
edit_list = double_redirects_query_result_to_edit_list(query_result)
total = len(edit_list)
print(f"Query returned {total} redirects that need editing.")
if total == 0:
    exit()

# If an argument was given to the script, it is the error log file
if len(sys.argv) > 1:
    logger = Logger(sys.argv[1])
    logger.write_row(['old_id', 'new_id', 'newer_id', 'error_type', 'error_message'])
else:
    logger = None

for index, [old_id, new_id, newer_id] in enumerate(edit_list):
    print(
        f"Changing redirect {old_id} to point directly to {newer_id} instead of {new_id} ({index + 1}/{total})"
    )

    params = {
        "action": "wbcreateredirect",
        "from": old_id,
        "to": newer_id,
    }

    try:
        result = mediawiki_api_call_helper(data=params, login=login)
        print(result)
    except Exception as err:
        if logger != None:
            logger.write_row([old_id, new_id, newer_id, type(err), err])
        print(f"Error while calling wbcreateredirect: {err}, {type(err)}")
    
