import sys
from wikibaseintegrator.wbi_helpers import execute_sparql_query

from config.wikibase_setup import wbi
from utils.csv_logger import Logger
from utils.utils import redirect_query_result_to_edit_list


single_redirect_query = """
SELECT ?subject ?predicate ?old ?new
WHERE {
  ?old owl:sameAs ?new .
  ?subject ?predicate ?old .
  ?subject wikibase:sitelinks [] . # Needed to filter on entities
  ?new wikibase:sitelinks [] .
}
"""
double_redirect_query = """
SELECT ?subject ?predicate ?old ?new
WHERE {
  ?old owl:sameAs ?middle .
  FILTER NOT EXISTS { ?middle wikibase:sitelinks [] }
  ?middle owl:sameAs ?new .
  ?new wikibase:sitelinks [] .
  ?subject ?predicate ?old .
  ?subject wikibase:sitelinks [] .
}
"""

print(f"Executing query to obtain entities that point to single redirects:\n{single_redirect_query}")
single_redirect_query_result = execute_sparql_query(single_redirect_query)
print(f"Executing query to obtain entities that point to double redirects:\n{double_redirect_query}")
double_redirect_query_result = execute_sparql_query(double_redirect_query)

# Deze hulpfunctie zet elke query result om naar een lijst met elementen
# van de vorm: [subject_id, old_id, new_id, predicate_id]
# Dit betekent dat bij subject_id, predicate id statement moet aangepast worden
# om old_id te vervangen door new_id
edit_list = redirect_query_result_to_edit_list(single_redirect_query_result)
edit_list += redirect_query_result_to_edit_list(double_redirect_query_result)
total = len(edit_list)
print(f"Queries returned {total} statements that need editing.")
if total == 0:
    exit()

# If an argument was given to the script, it is the error log file
if len(sys.argv) > 1:
    logger = Logger(sys.argv[1])
    logger.write_row(['subject_id', 'old_id', 'new_id', 'predicate_id', 'error_type', 'error_message'])
else:
    logger = None

for index, [subject_id, old_id, new_id, predicate_id] in enumerate(edit_list):
    print(f'Changing {predicate_id} on {subject_id}: {old_id} -> {new_id} ({index + 1}/{total})')
    subject = wbi.item.get(subject_id)
    claims = subject.claims.get(predicate_id)
    for claim in claims:
        if claim.mainsnak.datavalue['value']['id'] == old_id:
            claim.mainsnak.datavalue['value']['id'] = new_id
            claim.mainsnak.datavalue['value']['numeric-id'] = new_id[1:]
    try:
        subject.write(is_bot=True)
    except Exception as err:
        if logger != None:
            logger.write_row([subject_id, old_id, new_id, predicate_id, type(err), err])
        print(err)