import sys
from wikibaseintegrator.wbi_helpers import execute_sparql_query

from config.wikibase_setup import wbi
from utils.csv_logger import Logger
from utils.utils import query_result_to_entity_ids


# Je mag hier elke query schrijven die als resultaat een lijst van entiteiten geeft
# die je wilt verwijderen (geen andere velden in de reusultaten, de naam van de
# variabele, hier "subject", maakt niet uit)
query = """
SELECT ?subject
WHERE
{
?subject rdfs:label ?label .
FILTER REGEX (?label, "already has label", "i")
SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],nl,en" . }
}
"""
# Reden van verwijderen
reason = 'This was clutter left by an earlier merge.'

print(f'Executing query to obtain entity ids to delete:\n{query}')
query_result = execute_sparql_query(query)
entity_ids = query_result_to_entity_ids(query_result)
total = len(entity_ids)
print(f'Query returned {total} entity ids to delete.')
if total == 0:
    exit()

# If an argument was given to the script, it is the error log file
if len(sys.argv) > 1:
    logger = Logger(sys.argv[1])
    logger.write_row(['enitiy_id', 'error_type', 'error_message'])
else:
    logger = None

for index, entity_id in enumerate(entity_ids):
    print(f'deleting {entity_id} ({index + 1} of {total})')
    try:
        entity = wbi.item.get(entity_id)
        entity.delete(is_bot=True, reason=reason)
    except Exception as err:
        if logger != None:
            logger.write_row([entity_id, type(err), err])
        print(err)
