from wikibaseintegrator import WikibaseIntegrator
from wikibaseintegrator.wbi_config import config
from wikibaseintegrator.wbi_login import Login

from .secrets import password, user

# De nodige configuratie voor onze wikibase instantie
config['DEFAULT_LANGUAGE'] = 'nl'
config['WIKIBASE_URL'] = 'https://kg.kunsten.be'
config['MEDIAWIKI_API_URL'] = 'https://kg.kunsten.be/w/api.php'
config['MEDIAWIKI_INDEX_URL'] = 'https://kg.kunsten.be/w/index.php'
config['MEDIAWIKI_REST_URL'] = 'https://kg.kunsten.be/w/rest.php'
config['SPARQL_ENDPOINT_URL'] = (
    'https://kg.kunsten.be/query/proxy/wdqs/bigdata/namespace/wdq/sparql'
)
# De login van de bot account (niet zomaar online zetten / publiek delen!)
login = Login(user=user, password=password)
wbi = WikibaseIntegrator(login=login)